 NOLIST
 RADIX DEC 
; Predefined instructions; normallement elles sont dfinies, c'est par prcaution
#DEFINE CLR bcf
#DEFINE CLRB BCF
#DEFINE SETB bsf
#DEFINE CLRC bcf STATUS,C		; clear the Carry flag
#DEFINE SETC bsf STATUS,C		; set the Carry flag
#DEFINE SKPC btfss STATUS,C		; skip if C=1
#DEFINE SKPNC btfsc STATUS,C	; skip if C=0
#DEFINE SKPZ btfss STATUS,Z		; skip if Z=1
#DEFINE SKPNZ btfsc STATUS,Z	; skip if Z=0
#DEFINE CLRZ bcf STATUS,Z		; clear the Zero flag
#DEFINE SETZ bsf STATUS,Z		; set the Zero flag

#DEFINE BRA	GOTO			; absolute jump
#DEFINE JUMP	goto			; absolute jump

JB	macro Reg, Bit, Adr		; absolute jump if bit set
	  BTFSC	Reg, Bit
	  BRA	Adr
	endm

JNB	macro Reg, Bit, Adr		; absolute jump if bit clear
	  BTFSS	Reg, Bit
	  BRA	Adr
	endm

JZ	macro Adr			; absolute jump if zero
	  BTFSC	STATUS,Z
	  BRA	Adr
	endm

JNZ	macro Adr			; absolute jump if not zero
	  BTFSS	STATUS,Z
	  BRA	Adr
	endm

JC	macro Adr			; absolute jump if carry
	  BTFSC	STATUS,C
	  BRA	Adr
	endm

JNC	macro Adr			; absolute jump if not carry
	  BTFSS	STATUS,C
	  BRA	Adr
	endm

; Clear Digit Carry	     CLRDC	   BCF	    3,1 	  -
; Set Digit Carry	     SETDC	   BSF	    3,1 	  -
; Clear Zero		     CLRZ	   BCF	    3,2 	  -
; Set Zero		     SETZ	   BSF	    3,2 	  -
; Test File		     TSTF f	   MOVF     f,1 	  Z
; Move File to W	     MOVFW f	   MOVF     f,0 	  Z
; Negate File		     NEGF f,d	   COMF     f,1
;					   INCF     f,d 	  Z
; Add Carry to File	     ADDCF f,d	   BTFSC    3,0
;					   INCF     f,d 	  Z
; Subtract Carry from File   SUBCF f,d	   BTFSC    3,0
;					   DECF     f,d 	  Z
; Add Digit Carry to File    ADDDCF f,d    BTFSC    3,1
;					   INCF     f,d 	  Z
; Subtract Digit	     SUBDCF f,d    BTFSC    3,1
; Carry from File			   DECF     f,d 	  Z
; Branch		     B k	   GOTO     k		  -
; Branch on Carry	     BC k	   BTFSC    3,0
;					   GOTO     k		  -
; Branch on No Carry	     BNC k	   BTFSS    3,0
;					   GOTO     k		  -
; Branch on Digit Carry      BDC k	   BTFSC    3,1
;					   GOTO     k		  -
; Branch on No Digit Carry   BNDC k	   BTFSS    3,1
;					   GOTO     k		  -
; Branch on Zero	     BZ k	   BTFSC    3,2
;					   GOTO     k		  -
; Branch on Non Zero	     BNZ k	   BTFSS    3,2
;					   GOTO     k		  -
; Call across page boundary  LCALL k	   BCF 3,5 or BSF 3,5
;					   BCF 3,6 or BSF 3,6
;					   CALL     k


SetBank  MACRO Num		; Setbank <Num>
;	CLR  STATUS, RP1
	if Num & 1
	  SETB  STATUS, RP0
	  errorlevel	-302		; disable warning
	else
	  CLR  STATUS, RP0
	  errorlevel	+302		; Re-enable bank warning
	endif
	ENDM

Save_WnSTATUS MACRO
	MOVWF	W_TEMP		; Copy W to a Temporary Register regardless of current bank
	SWAPF	STATUS,W	; Swap STATUS nibbles and place into W register without affecting STATUS
	MOVWF	STATUS_TEMP	; Save STATUS to a Temporary register in Bank0
	CLRF	STATUS
	ENDM

Restore_WnSTATUS MACRO
	SWAPF	STATUS_TEMP,W ; Swap original STATUS register value into W (restores original bank)
	MOVWF	STATUS ; Restore STATUS register from W register
	SWAPF	W_TEMP,F ; Swap W_Temp nibbles and return value to W_Temp
	SWAPF	W_TEMP,W ; Swap W_Temp to W to restore original W value without affecting STATUS
	ENDM


ReadTMR1 MACRO a	;  lit TMR1 dans a ; 16 cycles ou 9 cycles
	MOVF	TMR1H,W
	MOVWF	a+1
	MOVF	TMR1L,W
	MOVWF	a
	MOVF	TMR1H,W
	SUBWF	a+1,W	; W=Timer1h-TMR1h, soustrait la premiere lecture  la lecture courante
	SKPNZ
	  GOTO	$+5
	MOVF	TMR1L,W	; ici, le point fort TMR1H vient de changer, on relit tout
	MOVWF	a	
	MOVF	TMR1H,W
	MOVWF	a+1
	ENDM

; Lecture d'une table en utilisant le principe RETLW
; pour viter les pbs de PCL:PCH et de page boundary, on construit le PCL:PCH en totalit
; la variable ind doit tre dclare dans le programme appelant
; selon AN556 ; la table doit tre du genre
;TABLEi
;	MOVWF PCL
;	RETLW 128
TABLE MACRO TABLEi,ind
	ADDLW	1		; petit gag oubli dans l'AN556
	MOVWF	ind
	MOVLW	LOW TABLEi
	ADDWF	ind,F
	MOVLW	HIGH TABLEi
	SKPNC
	  ADDLW	1
	MOVWF	PCLATH		; prepare right page bits for table read
	MOVF	ind,W
	CALL	TABLEi
 ENDM

;*********************************************************************************************
; initialisation du registre OPTION, bits timer
; bit 0,1,2	prdiviseur 0=F/8, 1=F/16, 2=F/32, 3=F/64, 4=F/128, 5=F/256, 6=F/512, 7=F/1024
; bit	3	PSA=0 prescaler sur timer, PSA=1 prescaler sur watchdog
; bit	4	T0SE timer source edge : T0SE=1 ngatif, T0SE=0 positif
; bit	5	T0CS timer clock select : T0CS=1 externe, T0CS=0 interne	

LOAD_OPTION MACRO value
 IFDEF code12b
 	MOVLW	value
	OPTION
 ENDIF
 IFDEF code14b
	SetBank 1
 	MOVLW	value
	MOVWF	OPTION_REG
	SetBank 0
 ENDIF
 ENDM

;*********************************************************************************************
; E2PROM routines

EERead	  MACRO EELoc ; usage EERead add
	    MOVLW	EELoc
	    SetBank	1
	    MOVWF	EEADR		; EEADR=EELoc
	    SETB	EECON1,RD
	    MOVF	EEDATA,W	; W=@EEADR
	    SetBank	0
	  ENDM

EEWrite   MACRO EELoc ; usage EEWrite EELoc E2PROM[EELoc]=W, EELoc est un litteral !! attention  peut durer 8ms
	    CLR		PIR1,EEIF
	    SetBank	1
	    MOVWF	EEDATA	; EEDATA=W
	    MOVLW	EELoc
	    MOVWF	EEADR	; EEADR=LitAdd
	    SETB	EECON1, WREN
	    CLR		INTCON,GIE	; disable interrupts
	    MOVLW	055h
	    MOVWF	EECON2
	    MOVLW	0AAh
	    MOVWF	EECON2
	    SETB	EECON1,WR
	    SETB	INTCON,GIE	; enable interrupts
	    SetBank	0
	  ENDM

EEWait MACRO
	BTFSS	PIR1,EEIF
	  GOTO	$-1
	CLR	PIR1,EEIF
	ENDM

;*********************************************************************************************
; comparaison

CJNE	MACRO	a,b,c	; compare and jump if a<>b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPZ
	  GOTO	c	; saut si Z=1, W<>0       a<>b
	ENDM

CJEQ	MACRO	a,b,c	; compare and jump if a=b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPNZ
	  GOTO	c	; compare and jump if a=b
	ENDM


CJGE	MACRO	a,b,c	; compare and jump if a>=b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPNC
	  GOTO	c	; saut si C=1, W positif ou nul  a >= b
	ENDM

CJGEF	MACRO	a,b,c	; compare and jump if a>=b, b file
	MOVF	b,W
	SUBWF	a,W	; W = a - b
	SKPNC
	  GOTO	c	; saut si C=1, W positif ou nul  a >= b
	ENDM

CJLT	MACRO	a,b,c	; compare and jump if a<b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPC
	  GOTO	c	; saut si C=0, W ngatif  a < b
	ENDM

CJLTF	MACRO	a,b,c	; compare and jump if a<b, b file
	MOVF	b,W
	SUBWF	a,W	; W = a - b
	SKPC
	  GOTO	c	; saut si C=0, W ngatif  a < b
	ENDM

CSEQ	MACRO	a,b	; compare and skip if a=b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPZ		; skip si C=0, W nul  a = b
	ENDM
	
CSGE	MACRO	a,b	; compare and skip if a>=b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPC		; skip si C=1, W positif ou nul  a >= b
	ENDM

CSGEF	MACRO	a,b	; compare and skip if a>=b
	MOVF	b,W
	SUBWF	a,W	; W = a - b
	SKPC		; skip si C=1, W positif ou nul  a >= b
	ENDM

CSLT	MACRO	a,b	; compare and skip if a<b, b litteral
	MOVLW	b
	SUBWF	a,W	; W = a - b
	SKPNC		; skip si C=0, W ngatif  a < b
	ENDM

CSLTF	MACRO	a,b	; compare and skip if a<b, b file
	MOVF	b,W
	SUBWF	a,W	; W = a - b
	SKPNC		; skip si C=0, W ngatif  a < b
	ENDM


CJLT16	MACRO	a,b,c	; compare and jump to c if a<b ; b litteral
	MOVLW	HIGH b	; W = high(b)
	SUBWF	a+1,W	; W = high(a) - high(b)
	SKPC
	  GOTO	c	; saut si C=0, W ngatif  high(a) < high(b)
	SKPZ
	  GOTO	$+5	; si high(a) > high(b), goto suite
	MOVLW	LOW b	; W = low(b)
	SUBWF	a,W	; W = low(a) - low(b)
	SKPC
	  GOTO	c	; saut si C=0, W ngatif  low(a) < low(b)
	ENDM

CLR16	MACRO a		; reset
	CLRF	a
	CLRF	a+1
	ENDM
	
D216	MACRO a		; divise par 2 NON SIGNE
	CLRC
	RRF	a+1,F
	RRF	a,F
	ENDM

D216s	MACRO a		; divise par 2  SIGNE
	RLF	a+1,W		; charge Carry avec bit poids fort
	RRF	a+1,F
	RRF	a,F
	ENDM

DEC16	MACRO a		; decrement 16 bits
	DECF	a,F		; decrmente l'adresse sur 16 bits
	COMF	a,W		; W=not a, si a=FF, il faut dcrmenter a+1
	SKPNZ
	  DECF	a+1,F
	ENDM

INC16	MACRO a		; increment 16 bits
	INCF	a,F		; incrmente l'adresse sur 16 bits
	SKPNZ
	  INCF	a+1,F
	ENDM

NEG16	MACRO	Xlow	; Negation d'une variable 16 bits	Neg16 toto
	COMF	Xlow,F		; complemente = XOR FF
	INCF	Xlow,F		; incremente, ici Xlow = -Xlow
	SKPNZ			; si zero, il faut propager la retenue sur l'octet haut
	  DECF	Xlow+1,F
	COMF	Xlow+1,F
 ENDM

ABS16	MACRO a
	RLF	a+1,W		; charge Carry avec bit poids fort
	SKPC
	 BRA	$+6		; si c'est positif, on sort
	COMF	a,F		; si c'est ngatif, on complmente et on ajoute 1
	COMF	a+1,F
	INCF	a,F
	SKPNZ
	  INCF	a+1,F
 ENDM
 
ADD16	MACRO	Xlow,Ylow,Zlow	; Addition 16 bits NON SIGNE Z = X + Y, X et Y inchangs
 	MOVF	Xlow,W
	ADDWF	Ylow,W		; W = Xlow + Ylow
	MOVWF	Zlow		; Zlow = W
	SKPC
	  MOVLW 0
	SKPNC
	  MOVLW	1
	ADDWF	Xlow+1,W	; W = Xhi [+1]
	ADDWF	Ylow+1,W	; W = W + Yhi
	MOVWF	Zlow+1
 ENDM

ADDLW16	MACRO	Xlow,Ylit,Zlow	; Addition 16 bits NON SIGNE Z = X + Y, X et Y inchangs
 	MOVF	Xlow,W
	ADDLW	LOW Ylit		; W = Xlow + Ylow
	MOVWF	Zlow		; Zlow = W
	SKPC
	  MOVLW 0
	SKPNC
	  MOVLW	1
	ADDWF	Xlow+1,W	; W = Xhi [+1]
	ADDLW	HIGH Ylit
	MOVWF	Zlow+1
 ENDM

SUBLW16	MACRO	Lit,DestL	; Soustraction 16 bits SIGNE, Dest = Dest - Lit
	MOVLW	LOW Lit
	SUBWF	DestL,F		; DestL = DestL - LitL

	MOVLW	HIGH Lit
	SKPC
	 ADDLW 1
	SUBWF	DestL+1,F           ;dest = dest - Lit, WITH VALID CARRY (although the Z flag is not valid)
;       Carry - NOT( Borrow result) ; Cy=0 if neg, Cy=1 if positive

	MOVF	DestL+1,F	; reconstruit le flag Z
	SKPNZ				;skip if MSbyte<>zero
	 MOVF	DestL,F		;else, check LSbyte for zero.
 ENDM


SUB16	MACRO	SourceL,DestL	; Soustraction 16 bits SIGNE, Dest = Dest - Source
	MOVF	SourceL,W
	SUBWF	DestL,F		; DestL = DestL - SourceL

	MOVF	SourceL+1,W
	SKPC
	 INCFSZ	SourceL+1,W ; ou ADDLW 1
	SUBWF	DestL+1,F           ;dest = dest - source, WITH VALID CARRY (although the Z flag is not valid)
;       Carry - NOT( Borrow result) ; Cy=0 if neg, Cy=1 if positive

	MOVF	DestL+1,F	; reconstruit le flag Z
	SKPNZ				;skip if MSbyte<>zero
	 MOVF	DestL,F		;else, check LSbyte for zero.
 ENDM

MOVLF	MACRO a,b	; move literal B dans registre A acces bank
	MOVLW	b
	MOVWF	a
 ENDM

MOVLF16	MACRO a,b	; move literal B dans registre A 16 bits
	MOVLW	LOW b
	MOVWF	a
	MOVLW	HIGH b
	MOVWF	a+1
 ENDM

COPY2 MACRO SourceL,DestL	; Dest=Source
	MOVF	SourceL,W
	MOVWF	DestL
	MOVF	SourceL+1,W
	MOVWF	DestL+1
 ENDM

COPY	macro	from,to		; Copy bytes in register file via W
	MOVF	from,W
	MOVWF	to
	endm

;SUBC (substract with Carry) soustraction avec retenue scrit en RISC PIC 16 :
;	SKPC
;	 INCF Xlow,F
;	SUBWF Xlow,F

;*******************************************************************
; MULTIPLY 8x8 unsigned
;       Performance :
;                    Program Memory  :  13 words (excluding call & return)
;                    # of cycles     :  69       (excluding call & return)
;                    Scratch RAM     :  1 byte
;                    W Register      :  Used
;*******************************************************************
;
MULWF MACRO	Reg	; PRODH:PRODL = W * Reg, unsigned, Reg altered, LoopCount needed....
	LOCAL	MULWFl
	CLRF	PRODH
	CLRF	PRODL
	CLRF	LoopCount
	SETB	LoopCount,3	; set count = 8, sans toucher WREG !!
	CLRC	;  quoi sert cette instruction ?
MULWFl
	RRF	Reg,F			; Reg=Reg/2
	SKPNC				; si le bit faible de Reg=1
	 ADDWF	PRODH,F		;   alors Prod=Prod+mulcnd*256
	RRF	PRODH,F			; Prod=Prod/2, avec la carry ventuellement mise par l'instruction ADDWF prcdente
	RRF	PRODL,F
	DECFSZ	LoopCount,F
	 GOTO	MULWFl
	ENDM
 LIST